//
//  MCTimeZoneComboBoxController.h
//  MCApplication
//
//  Created by Brent Gulanowski on 06/07/07.
//  Copyright 2007 Marketcircle, Inc. All rights reserved.
//
//  Description


#import <Cocoa/Cocoa.h>

@class MCTimeZoneProxy;


@interface MCTimeZoneComboBoxController : NSObject {

	IBOutlet NSComboBox *timeZoneComboBox;
	IBOutlet NSArrayController *timeZonesAC;
	NSString *timeZoneNameFilter;
	
	BOOL ignoreControlTextChange;
}

-(NSString *)timeZoneNameFilter;
-(void)setTimeZoneNameFilter:(NSString *)string;
-(NSPredicate *)searchPredicate;

- (void)controlTextDidChange:(NSNotification *)aNotification;
- (void)tigerControlTextDidChange:(NSNotification *)aNotification;
- (void)leopardControlTextDidChange:(NSNotification *)aNotification;

- (BOOL)control:(NSControl *)control textShouldEndEditing:(NSText *)fieldEditor;
- (void)comboBoxSelectionDidChange:(NSNotification *)notification;

-(MCTimeZoneProxy *)selection;
-(void)configureWithSelectedTimeZone:(MCTimeZoneProxy *)tz;
@end
